#include <allegro.h>

#include "main.h"
#include "chatbox.h"

CHATBOX *chatbox = NULL;

void chatbox_init()
{
	chatbox = (CHATBOX *)malloc(sizeof(CHATBOX));

	chatbox->head = NULL;
	chatbox->current = NULL;
	chatbox->bmp = create_bitmap(320, 8);
	clear(chatbox->bmp);
	chatbox->auto_advance = TRUE;

	chatbox->overlay = gfx_add_overlay(gfx, chatbox->bmp, 0,192, 1);
}

void chatbox_add(int player, char *message)
{
	CB_LINE *line = (CB_LINE*) malloc(sizeof(CB_LINE));
	line->player = player;
	strncpy(line->message, message, 40);
	line->message[39] = 0;
	line->ts = 0;

	line->next = chatbox->head;
	line->prev = NULL;

	if (chatbox->head) chatbox->head->prev = line;
	if (!chatbox->current) chatbox->current = line;	
	chatbox->head = line;

	chatbox_update();
	chatbox_draw();
}

/*
	These prev/next functions appear to be misnamed, but it's just because the most recent
	messages appear first in the linked list. Thus, to go back to read an old message, you
	must advanced to the next pointer.
*/
void chatbox_previous()
{
	if (!chatbox->current)
		chatbox->current = chatbox->head;
	else if (chatbox->current->next)
		chatbox->current = chatbox->current->next;
	
	if (chatbox->current)
	{
		chatbox->current->ts = time(0);
		chatbox_draw();
		
		/* if at start of linked list, then turn auto cycle back on */
		chatbox->auto_advance = chatbox->current->prev ? FALSE : TRUE;
	}
}

void chatbox_next()
{
	if (!chatbox->current)
		chatbox->current = chatbox->head;
	else if (chatbox->current->prev)
		chatbox->current = chatbox->current->prev;

	if (chatbox->current)
	{
		chatbox->current->ts = time(0);
		chatbox_draw();
		
		/* if at start of linked list, then turn auto cycle back on */
		chatbox->auto_advance = chatbox->current->prev ? FALSE : TRUE;
	}
}

void chatbox_update()
{
	if (chatbox->auto_advance && chatbox->current)
	{
		if (chatbox->current->prev && chatbox->current->ts + 3 < time(0))
		{
			chatbox->current = chatbox->current->prev;
			chatbox->current->ts = time(0);
			chatbox_draw();
		}
		else if (!chatbox->current->prev && chatbox->current->ts + 10 < time(0))
		{
			/* time stamp is 0 on first view, so don't disable it */
			if (chatbox->current->ts) chatbox->current = NULL;
			else chatbox->current->ts = time(0);
			chatbox_draw();
		}
	}
}

void chatbox_draw()
{
	clear(chatbox->bmp);
	if (chatbox->current)
	{
		if (chatbox->current->next) textprintf_ex(chatbox->bmp, font64, 0,0, chatbox->current->next->player+4,0, "%c", '-');
		textprintf_ex(chatbox->bmp, font64, 8,0, chatbox->current->player+4,0, "%s", chatbox->current->message);
		if (chatbox->current->prev) textprintf_ex(chatbox->bmp, font64, 312,0, chatbox->current->prev->player+4,0, "%c", '+');
	}
}

void chatbox_shutdown()
{
	CB_LINE *current = chatbox->head;
	while (current)
	{
		CB_LINE *tmp = current->next;
		free(current);
		current = tmp;
	}

	chatbox->head = NULL;
	gfx_remove_overlay(gfx, chatbox->overlay);
	destroy_bitmap(chatbox->bmp);

	chatbox = NULL;
}